// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 12, Aufgabe 6
// "Notenstatistik"

//---------------------------------------------------
// class Student
//---------------------------------------------------
class Student {
	String name;
	Exam exams;
	Student next;
	Student(String name) { this.name = name; }
	void addExam(Exam e) { e.next = exams; exams = e; }
}

//---------------------------------------------------
// class Exam
//---------------------------------------------------
class Exam {
	String course;
	int grade;
	Exam next;
	Exam(String course, int grade) { this.course = course; this.grade = grade; }
}

//---------------------------------------------------
// class StudentList
//---------------------------------------------------
class StudentList {
	Student first = null;
	
	// Insert a student into the list
	Student insert(String name) {
		Student s = first, last = null;
		while (s != null && name.compareTo(s.name) > 0) {
			last = s; s = s.next;
		}
		Student x = new Student(name);
		x.next = s;
		if (s == first) first = x; else last.next = x;
		return x;
	}
	
	// Return the student with the given name from the list
	Student find(String name) {
		Student s = first;
		while (s != null && name.compareTo(s.name) > 0) s = s.next;
		if (s != null && name.equals(s.name)) return s; else return null;
	}
	
	// Print the student list
	void print() {
		for (Student s = first; s != null; s = s.next) {
			Out.println(s.name);
			for (Exam e = s.exams; e != null; e = e.next)
				Out.println("  " + e.course + "  " + e.grade);
		}
	}
}

//---------------------------------------------------
// Test program
//---------------------------------------------------
public class A6 {
	
	public static void main(String args[]) {
		StudentList list = new StudentList();
		In.open("input.txt");
		String course = In.readString();
		while (In.done()) {
			String studName = In.readString();
			while (!studName.equals("END")) {
				int grade = In.readInt();
				Student s = list.find(studName);
				if (s == null) s = list.insert(studName);
				s.addExam(new Exam(course, grade));
				studName = In.readString();
			}
			course = In.readString();
		}
		In.close();
		list.print();
	}
}

/*
Sample input:
"Programmieren"
"Muster Max" 2
"Hoeller Anna" 1
"Buerger Josef" 3
"Hintersteiner Alex" 5
"Blau Maria" 2
"END"

"Technische Informatik"
"Hoeller Anna" 3
"Wassermann Doris" 2
"Muster Max" 3
"END"

"VLSI Design"
"Steiner Hans" 1
"Zeller Anna" 2
"Muster Max" 3
"Blau Maria" 2
"END"
*/